<?php
/**
 * Add Referral
 *
 * @package     AutomatorWP\Integrations\Easy_Affiliate\Actions\Add_Referral
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_Easy_Affiliate_Add_Referral extends AutomatorWP_Integration_Action {

    public $integration = 'easy_affiliate';
    public $action = 'easy_affiliate_register_sale';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_action( $this->action, array(
            'integration'       => $this->integration,
            'label'             => __( 'Add referral to user', 'automatorwp-pro' ),
            'select_option'     => __( 'Add <strong>referral</strong> to user', 'automatorwp-pro' ),
            /* translators: %1$s: Referral. */
            'edit_label'        => sprintf( __( 'Add %1$s to user', 'automatorwp-pro' ), '{referral}' ),
            /* translators: %1$s: Referral. */
            'log_label'         => sprintf( __( 'Add %1$s to user', 'automatorwp-pro' ), '{referral}' ),
            'options'           => array(
                'referral' => array(
                    'default' => __( 'referral', 'automatorwp-pro' ),
                    'fields' => array(
                        'name' => array(
                            'name' => __( 'Customer name:', 'automatorwp-pro' ),
                            'type' => 'text',
                            'default' => ''
                        ),
                        'email' => array(
                            'name' => __( 'Customer email:', 'automatorwp-pro' ),
                            'type' => 'text',
                            'default' => ''
                        ),
                        'item_name' => array(
                            'name' => __( 'Product name:', 'automatorwp-pro' ),
                            'type' => 'text',
                            'default' => ''
                        ),
                        'order_id' => array(
                            'name' => __( 'Order ID:', 'automatorwp-pro' ),
                            'type' => 'text',
                            'default' => '',
                            'required' => true,
                        ),
                        'transaction_source' => array(
                            'name' => __( 'Transaction Source:', 'automatorwp-pro' ),
                            'type' => 'select',
                            'options_cb' => array( $this, 'transaction_sources_options_cb' ),
                            'required' => true,
                            'default' => 'general'
                        ),
                        'amount' => array(
                            'name' => __( 'Amount:', 'automatorwp-pro' ),
                            'type' => 'text',
                            'attributes' => array(
                                'type' => 'number'
                            ),
                            'default' => '0.00'
                        ),
                        'refund' => array(
                            'name' => __( 'Refund amount:', 'automatorwp-pro' ),
                            'type' => 'text',
                            'attributes' => array(
                                'type' => 'number'
                            ),
                            'default' => '0.00'
                        ),
                        
                    )
                )
            ),
        )
    );

    }

    /**
     * Get referral types options
     *
     * @since 1.0.0
     *
     * @return array
     */
    public function transaction_sources_options_cb() {

        $options = array();

        $options = array(
            'general'   => __( 'General', 'automatorwp-pro' ),
            'memberpress'      => __( 'MemberPress', 'automatorwp-pro' ),
            'woocommerce'    => __( 'WooCommerce', 'automatorwp-pro' ),
            'easy_digital_downloads'  => __( 'Easy Digital Downloads', 'automatorwp-pro' ),
            'wpforms'  => __( 'WPForms', 'automatorwp-pro' ),
            'formidable'  => __( 'Formidable', 'automatorwp-pro' ),
            'paypal'  => __( 'PayPal', 'automatorwp-pro' ),
        );

        return $options;

    }

    /**
     * Action execution function
     *
     * @since 1.0.0
     *
     * @param stdClass  $action             The action object
     * @param int       $user_id            The user ID
     * @param array     $action_options     The action's stored options (with tags already passed)
     * @param stdClass  $automation         The action's automation object
     */
    public function execute( $action, $user_id, $action_options, $automation ) {

        $this->result = '';

        // Bail if no user
        if( absint( $user_id === 0) ) {
            return;
        }

        $user_affiliate = get_user_meta( $user_id, 'wafp_is_affiliate', true );
        // Bail if user is affiliated
        if ( ! isset ( $user_affiliate ) ) {
            $this->result = __( 'User is not an affiliate.', 'automatorwp-pro' );
            return;
        }

        if ( empty( $action_options['order_id'] ) ) {
            $this->result = __( 'Order ID cannot be empty.', 'automatorwp-pro' );
            return;
        }
		
		$referral = array();

		$referral['referrer']                        = $user_id;
		$referral['_wafp_transaction_cust_name']     = $action_options['name'];
		$referral['_wafp_transaction_cust_email']    = $action_options['email'];;
		$referral['_wafp_transaction_item_name']     = $action_options['item_name'];
		$referral['_wafp_transaction_trans_num']     = $action_options['order_id'];
		$referral['_wafp_transaction_source']        = $action_options['transaction_source'];
		$referral['_wafp_transaction_refund_amount'] = $action_options['refund'];
		$referral['_wafp_transaction_sale_amount']   = $action_options['amount'];

		$transaction = new EasyAffiliate\Models\Transaction();
		$transaction->load_from_sanitized_array( $referral );
		$transaction->affiliate_id = $referral['referrer'];

        // To apply refund
		$transaction->apply_refund( $referral['_wafp_transaction_refund_amount'] );

		$id = $transaction->store();
        
    }

   /**
     * Register required hooks
     *
     * @since 1.0.0
     */
    public function hooks() {

        // Log meta data
        add_filter( 'automatorwp_user_completed_action_log_meta', array( $this, 'log_meta' ), 10, 5 );

        // Log fields
        add_filter( 'automatorwp_log_fields', array( $this, 'log_fields' ), 10, 5 );

        parent::hooks();

    }    

    /**
     * Action custom log meta
     *
     * @since 1.0.0
     *
     * @param array     $log_meta           Log meta data
     * @param stdClass  $action             The action object
     * @param int       $user_id            The user ID
     * @param array     $action_options     The action's stored options (with tags already passed)
     * @param stdClass  $automation         The action's automation object
     *
     * @return array
     */
    public function log_meta( $log_meta, $action, $user_id, $action_options, $automation ) {

        // Bail if action type don't match this action
        if( $action->type !== $this->action ) {
            return $log_meta;
        }

        // Store the action's result
        $log_meta['result'] = $this->result;

        return $log_meta;
    }

    /**
     * Action custom log fields
     *
     * @since 1.0.0
     *
     * @param array     $log_fields The log fields
     * @param stdClass  $log        The log object
     * @param stdClass  $object     The trigger/action/automation object attached to the log
     *
     * @return array
     */
    public function log_fields( $log_fields, $log, $object ) {

        // Bail if log is not assigned to an action
        if( $log->type !== 'action' ) {
            return $log_fields;
        }

        // Bail if action type don't match this action
        if( $object->type !== $this->action ) {
            return $log_fields;
        }

        $log_fields['result'] = array(
            'name' => __( 'Result:', 'automatorwp-pro' ),
            'type' => 'text',
        );

        return $log_fields;
    }    


}

new AutomatorWP_Easy_Affiliate_Add_Referral();